%Dependencies: rgb function that generates colors, can be replaced by
%simply selecting standard matlab colors.

clear
close all
%Save directory for figures
fig_dir=pwd;

%Loads processed data
load('metadata_duty_700M.mat');
ref=load('ref_data_700M.mat');

%Figure number to be plotted in
fig_no=10;

%Sets axis range and generates vector for plotting fits
x_min=0;
x_max=max(cellfun(@(x) max(x),x_mean));
x_vec=linspace(x_min,x_max,1e4);

%Size of each subplot
ax_size=4.4;

%Flip order of graphs, such that the highest number of duty cycles appears
%first
y_mean=flipud(y_mean);
x_mean=flipud(x_mean);
comb_ind=fliplr(comb_ind);

fig=figure(fig_no);

for i=1:length(y_mean)
    %Sets relevant subplot and axis
    subplot(1,3,i)
    ax(i)=gca;
    
    hold on
    %Indices for values that are outside the strobes and below a threshold
    new_ind=~comb_ind{i} & y_mean{i}<0.07;
    
    %Plots the data points in the strobes in red
    plot(x_mean{i}(~new_ind),y_mean{i}(~new_ind),...
        'Color',rgb('red'),'Marker','.',...
        'LineStyle','none','MarkerSize',2);
        
    %Plots the data points outside the strobes in gray
    plot(x_mean{i}(new_ind),y_mean{i}(new_ind),...
        'Color',rgb('light gray'),'Marker','.',...
        'LineStyle','none','MarkerSize',2);
    
    %Plots the line from the averaged reference in red on each subplot
    ref_line=plot(ref.x_mean,ref.y_mean,'Color',[rgb('red'),0.3]);
    
    %Draws two ticks
    set(ax(i), 'YTick',[1e-1,1])
    
    %Labels the plot if it is on the edge
    if i==1
        ylabel('Amp. (norm.)')
    else
        set(gca,'YTickLabel',[]);
    end
    
    set(ax(i),'YScale','Log');
    axis([0,420,0.007,1.2]);
    axis square
    box on
    
    %Plots the fit to the strobe
    plot(x_vec,fitdatas{i}(x_vec),'Color','k','LineStyle',':')
end

%Sizes the plots
for i=1:length(ax)
    ax(i).Units='centimeters';
    ax(i).Position=[2+5*mod(i-1,3),ax(i).Position(2),ax_size,ax_size];
    ax(i).LineWidth=1;
end
set(fig,'Color','w')

%Saves the plot as a PDF
makePDF_klab(fig_no,sprintf('DutySI'),18,6,fig_dir)